/*
Uploadify v2.1.0
Release Date: August 24, 2009

Copyright (c) 2009 Ronnie Garcia, Travis Nickels

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

(function(jQuery){
		jQuery.extend(jQuery.fn,{
			uploadify:function(options) {
				
				jQuery(this).each(function(){
					settings = jQuery.extend({
					id             : jQuery(this).attr('id'), // The ID of the object being Uploadified
					uploader       : 'uploadify.swf', // The path to the uploadify swf file
					script         : 'uploadify.php', // The path to the uploadify backend upload script
					expressInstall : null, // The path to the express install swf file
					folder         : '', // The path to the upload folder
					height         : 30, // The height of the flash button
					width          : 110, // The width of the flash button
					cancelImg      : 'cancel.png', // The path to the cancel image for the default file queue item container
					wmode          : 'opaque', // The wmode of the flash file
					scriptAccess   : 'sameDomain', // Set to "always" to allow script access across domains
					fileDataName   : 'Filedata', // The name of the file collection object in the backend upload script
					method         : 'POST', // The method for sending variables to the backend upload script
					queueSizeLimit : 999, // The maximum size of the file queue
					simUploadLimit : 1, // The number of simultaneous uploads allowed
					queueID        : false, // The optional ID of the queue container
					displayData    : 'percentage', // Set to "speed" to show the upload speed in the default queue item
					onInit         : function() {}, // Function to run when uploadify is initialized
					onSelect       : function() {}, // Function to run when a file is selected
					onQueueFull    : function() {}, // Function to run when the queue reaches capacity
					onCheck        : function() {}, // Function to run when script checks for duplicate files on the server
					onCancel       : function() {}, // Function to run when an item is cleared from the queue
					onError        : function() {}, // Function to run when an upload item returns an error
					onProgress     : function() {}, // Function to run each time the upload progress is updated
					onComplete     : function() {}, // Function to run when an upload is completed
					onAllComplete  : function() {}  // Functino to run when all uploads are completed
				}, options);
					
				var pagePath = location.pathname;
				pagePath = pagePath.split('/');
				pagePath.pop();
				pagePath = pagePath.join('/') + '/';
				
				var data = {};
				data.uploadifyID = settings.id;
				data.pagepath = pagePath;
				
				if (settings.buttonImg) data.buttonImg = escape(settings.buttonImg);
				if (settings.buttonText) data.buttonText = escape(settings.buttonText);
				if (settings.rollover) data.rollover = true;
				
				data.script = settings.script;
				data.folder = escape(settings.folder);
				
				if (settings.scriptData) {
					var scriptDataString = '';
					for (var name in settings.scriptData) {
						scriptDataString += '&' + name + '=' + settings.scriptData[name];
					}
					data.scriptData = escape(scriptDataString.substr(1));
				}
				
				data.width          = settings.width;
				data.height         = settings.height;
				data.wmode          = settings.wmode;
				data.method         = settings.method;
				data.queueSizeLimit = settings.queueSizeLimit;
				data.simUploadLimit = settings.simUploadLimit;
				if (settings.hideButton)   data.hideButton   = true;
				if (settings.fileDesc)     data.fileDesc     = settings.fileDesc;
				if (settings.fileExt)      data.fileExt      = settings.fileExt;
				if (settings.multi)        data.multi        = true;
				if (settings.auto)         data.auto         = true;
				if (settings.sizeLimit)    data.sizeLimit    = settings.sizeLimit;
				if (settings.checkScript)  data.checkScript  = settings.checkScript;
				if (settings.fileDataName) data.fileDataName = settings.fileDataName;
				if (settings.queueID)      data.queueID      = settings.queueID;
				
				if (settings.onInit() !== false) {
					jQuery(this).css('display','none');
					jQuery(this).after('<div id="' + jQuery(this).attr('id') + 'Uploader"></div>');
					swfobject.embedSWF(settings.uploader, settings.id + 'Uploader', settings.width, settings.height, '9.0.24', settings.expressInstall, data, {'quality':'high','wmode':settings.wmode,'allowScriptAccess':settings.scriptAccess});
					if (settings.queueID == false) {
						jQuery("#" + jQuery(this).attr('id') + "Uploader").after('<div id="' + jQuery(this).attr('id') + 'Queue" class="uploadifyQueue"></div>');
					}
				}
				if (typeof(settings.onOpen) == 'function') {
					jQuery(this).bind("uploadifyOpen", settings.onOpen);
				}
				jQuery(this).bind("uploadifySelect", {'action': settings.onSelect, 'queueID': settings.queueID}, function(event, ID, fileObj) {
					if (event.data.action(event, ID, fileObj) !== false) {
						var byteSize = Math.round(fileObj.size / 1024 * 100) * .01;
						var suffix = 'KB';
						if (byteSize > 1000) {
							byteSize = Math.round(byteSize *.001 * 100) * .01;
							suffix = 'MB';
						}
						var sizeParts = byteSize.toString().split('.');
						if (sizeParts.length > 1) {
							byteSize = sizeParts[0] + '.' + sizeParts[1].substr(0,2);
						} else {
							byteSize = sizeParts[0];
						}
						if (fileObj.name.length > 20) {
							fileName = fileObj.name.substr(0,20) + '...';
						} else {
							fileName = fileObj.name;
						}
						queue = '#' + jQuery(this).attr('id') + 'Queue';
						if (event.data.queueID) {
							queue = '#' + event.data.queueID;
						}
						jQuery(queue).append('<div id="' + jQuery(this).attr('id') + ID + '" class="uploadifyQueueItem">\
								<div class="cancel">\
									<a href="javascript:jQuery(\'#' + jQuery(this).attr('id') + '\').uploadifyCancel(\'' + ID + '\')"><img src="' + settings.cancelImg + '" border="0" /></a>\
								</div>\
								<span class="fileName">' + fileName + ' (' + byteSize + suffix + ')</span><span class="percentage"></span>\
								<div class="uploadifyProgress">\
									<div id="' + jQuery(this).attr('id') + ID + 'ProgressBar" class="uploadifyProgressBar"><!--Progress Bar--></div>\
								</div>\
							</div>');
					}
				});
				if (typeof(settings.onSelectOnce) == 'function') {
					jQuery(this).bind("uploadifySelectOnce", settings.onSelectOnce);
				}
				jQuery(this).bind("uploadifyQueueFull", {'action': settings.onQueueFull}, function(event, queueSizeLimit) {
					if (event.data.action(event, queueSizeLimit) !== false) {
						alert('The queue is full.  The max size is ' + queueSizeLimit + '.');
					}
				});
				jQuery(this).bind("uploadifyCheckExist", {'action': settings.onCheck}, function(event, checkScript, fileQueueObj, folder, single) {
					var postData = new Object();
					postData = fileQueueObj;
					postData.folder = pagePath + folder;
					if (single) {
						for (var ID in fileQueueObj) {
							var singleFileID = ID;
						}
					}
					jQuery.post(checkScript, postData, function(data) {
						for(var key in data) {
							if (event.data.action(event, checkScript, fileQueueObj, folder, single) !== false) {
								var replaceFile = confirm("Do you want to replace the file " + data[key] + "?");
								if (!replaceFile) {
									document.getElementById(jQuery(event.target).attr('id') + 'Uploader').cancelFileUpload(key, true,true);
								}
							}
						}
						if (single) {
							document.getElementById(jQuery(event.target).attr('id') + 'Uploader').startFileUpload(singleFileID, true);
						} else {
							document.getElementById(jQuery(event.target).attr('id') + 'Uploader').startFileUpload(null, true);
						}
					}, "json");
				});
				jQuery(this).bind("uploadifyCancel", {'action': settings.onCancel}, function(event, ID, fileObj, data, clearFast) {
					if (event.data.action(event, ID, fileObj, data, clearFast) !== false) {
						var fadeSpeed = (clearFast == true) ? 0 : 250;
						jQuery("#" + jQuery(this).attr('id') + ID).fadeOut(fadeSpeed, function() { jQuery(this).remove() });
					}
				});
				if (typeof(settings.onClearQueue) == 'function') {
					jQuery(this).bind("uploadifyClearQueue", settings.onClearQueue);
				}
				var errorArray = [];
				jQuery(this).bind("uploadifyError", {'action': settings.onError}, function(event, ID, fileObj, errorObj) {
					if (event.data.action(event, ID, fileObj, errorObj) !== false) {
						var fileArray = new Array(ID, fileObj, errorObj);
						errorArray.push(fileArray);
						jQuery("#" + jQuery(this).attr('id') + ID + " .percentage").text(" - " + errorObj.type + " Error");
						jQuery("#" + jQuery(this).attr('id') + ID).addClass('uploadifyError');
					}
				});
				jQuery(this).bind("uploadifyProgress", {'action': settings.onProgress, 'toDisplay': settings.displayData}, function(event, ID, fileObj, data) {
					if (event.data.action(event, ID, fileObj, data) !== false) {
						jQuery("#" + jQuery(this).attr('id') + ID + "ProgressBar").css('width', data.percentage + '%');
						if (event.data.toDisplay == 'percentage') displayData = ' - ' + data.percentage + '%';
						if (event.data.toDisplay == 'speed') displayData = ' - ' + data.speed + 'KB/s';
						if (event.data.toDisplay == null) displayData = ' ';
						jQuery("#" + jQuery(this).attr('id') + ID + " .percentage").text(displayData);
					}
				});
				jQuery(this).bind("uploadifyComplete", {'action': settings.onComplete}, function(event, ID, fileObj, response, data) {
					if (event.data.action(event, ID, fileObj, unescape(response), data) !== false) {
						jQuery("#" + jQuery(this).attr('id') + ID + " .percentage").text(' - Completed');
						jQuery("#" + jQuery(this).attr('id') + ID).fadeOut(250, function() { jQuery(this).remove()});
					}
				});
				if (typeof(settings.onAllComplete) == 'function') {
					jQuery(this).bind("uploadifyAllComplete", {'action': settings.onAllComplete}, function(event, uploadObj) {
						if (event.data.action(event, uploadObj) !== false) {
							errorArray = [];
						}
					});
				}
			});
		},
		uploadifySettings:function(settingName, settingValue, resetObject) {
			var returnValue = false;
			jQuery(this).each(function() {
				if (settingName == 'scriptData' && settingValue != null) {
					if (resetObject) {
						var scriptData = settingValue;
					} else {
						var scriptData = jQuery.extend(settings.scriptData, settingValue);
					}
					var scriptDataString = '';
					for (var name in scriptData) {
						scriptDataString += '&' + name + '=' + escape(scriptData[name]);
					}
					settingValue = scriptDataString.substr(1);
				}
				
//				alert(jQuery(this).attr('id') + 'Uploader');
				
				returnValue = document.getElementById(jQuery(this).attr('id') + 'Uploader').updateSettings(settingName, settingValue);
			});
			if (settingValue == null) {
				if (settingName == 'scriptData') {
					var returnSplit = unescape(returnValue).split('&');
					var returnObj   = new Object();
					for (var i = 0; i < returnSplit.length; i++) {
						var iSplit = returnSplit[i].split('=');
						returnObj[iSplit[0]] = iSplit[1];
					}
					returnValue = returnObj;
				}
				return returnValue;
			}
		},
		uploadifyUpload:function(ID) {
			jQuery(this).each(function() {
				document.getElementById(jQuery(this).attr('id') + 'Uploader').startFileUpload(ID, false);
			});
		},
		uploadifyCancel:function(ID) {
			jQuery(this).each(function() {
				document.getElementById(jQuery(this).attr('id') + 'Uploader').cancelFileUpload(ID, true, false);
			});
		},
		uploadifyClearQueue:function() {
			jQuery(this).each(function() {
				document.getElementById(jQuery(this).attr('id') + 'Uploader').clearFileUploadQueue(false);
			});
		}
	})
})(jQuery);


/*

ZineScripts uploadify modifications
Copyright (c) 2009 ZineScripts

*/

var manager = {
	currentFile:{},
	files:[],
	interval:null,
	intervals:{},
	averageSpeed:{totSize:0},
	
	removeQueueFile	: function(id){
		var pos;
		if((pos = $.inArray(id,this.files))!=-1)
		{
			for(var i=pos+1;i<this.files.length;i++)
				this.files[i-1]=this.files[i];
				
			this.files.pop();
		}
	},
	
	clearIntervals : function(){
	
		clearInterval(this.intervals.ajaxCheck);
		clearInterval(this.intervals.percentage);
		this.intervals = {};
	},
	
	startUpload :function(){
		
		var man=this;
		
		var tmp = man.files.shift();
		if(!tmp)
		{
			$("#uploadify").uploadifyClearQueue();
			man.restoreButtons();
			man.clearIntervals();
			return false;
		}
		
		var cf = man.currentFile = {
			
			file			: tmp,
			start			: (new Date()).getTime(),
			cancelLink		: $('#uploadify'+tmp+' a'),
			uploadifyItem	: $('#uploadify'+tmp),
			progressBar		: $('#uploadify'+tmp+'ProgressBar'),
			percentSpan		: $('#uploadify'+tmp+' .percentage')
		};
		
		
		cf.percentSpan.html('&nbsp;-&nbsp;0%');
		
		if($(document).data(cf.file)>parseInt($('#maxUploadFileSize').text()))
		{
			cf.uploadifyItem.addClass('uploadifyError');
			$("#uploadify").uploadifyCancel(cf.file);
			
			cf.cancelLink.click(function(){cf.uploadifyItem.fadeOut('fast');});
			
			man.setError("File is too big");
			
			return false;
		}
		
		$('#uploadify').uploadifyUpload(cf.file);
//		console.log('starting..');
		cf.cancelLink.click(function(e){

			if(cf.uploadifyItem.hasClass('uploadifyError'))
			{
				cf.uploadifyItem.fadeOut('fast',function(){

					reinitJScroll();
					if(!man.files.length && cf.finish) man.restoreButtons();
				});
			}
			e.preventDefault();
		});

		var time = 0;
		if(man.averageSpeed.bitsPerSecond)
			time = Math.round($(document).data(cf.file)/man.averageSpeed.bitsPerSecond);

		cf.progressBar.gradualAnimation(time);
		man.monitorPercentage();
	},

	autoChecker : function(checkID){
		var man = this;
		man.failsafe=0;

		if(checkID && checkID!=man.currentFile.file) return false;

		clearInterval(man.intervals.ajaxCheck);

		if(!man.currentFile.finish && !man.currentFile.error)
		{
			man.intervals.ajaxCheck = setInterval(function(){

				if(++man.failsafe>240) // 10 min
				{
					man.clearIntervals();
					return false;
				}

				$.ajx('checkupload','fileKey='+man.currentFile.file,function(msg){

						if(msg.status && man.currentFile.file == checkID)
						{
							clearInterval(man.intervals.ajaxCheck);
							
							if(msg.status!=1)
								man.setError(msg.status);
							else
							{
								man.remove(man.currentFile.file);
								man.ok(man.currentFile.file);
							}
						}
				});
			}, 2500);
		}
	},

	setError : function(error){
		var man = this;
		
		man.currentFile.uploadifyItem.addClass('uploadifyError');
		man.currentFile.percentSpan.html("&nbsp;-&nbsp;"+error);
		man.currentFile.progressBar.stop().data('stopEnlarge',true);
		
		man.clearIntervals();
		man.startUpload();
	},
	
	remove : function(queueID){
		if(queueID!=this.currentFile.file) return false;
		
		clearInterval(this.intervals.ajaxCheck);
		
		var man = this;
		man.currentFile.progressBar.stopAnimation().animate({'width':'100%'}, 'slow',function(){

			man.currentFile.uploadifyItem.fadeOut('fast',function(){

				$('.uploadifyQueueItem:hidden').remove();
				reinitJScroll();
				clearInterval(man.intervals.percentage);
				man.startUpload();
			});
		});
		
		if(man.averageSpeed.totSize>500000 && man.averageSpeed.begin)
		{
			var dif = (new Date()).getTime() - man.averageSpeed.begin;
			man.averageSpeed.bitsPerSecond = Math.round(man.averageSpeed.totSize / Math.round(dif/1000));
		}
	},
	
	setPercentage: function(percent){
		this.currentFile.percentSpan.html('&nbsp;-&nbsp;'+percent+'%');
	},
	
	monitorPercentage: function(){
		var man = this;
		clearInterval(man.intervals.percentage);
		
		man.intervals.percentage = setInterval(function(){

			var percentage = parseInt(man.currentFile.progressBar.css('width'));
			
			if(!percentage || man.currentFile.percentage >= percentage || percentage>100)
			{
				if(percentage>100)
					clearInterval(man.intervals.percentage);
				return false;
			}

			man.currentFile.percentage = percentage
			man.setPercentage(percentage);
		},100);
	},
	restoreButtons: function(){
		$('#galleryUpload-screen .subAction').removeClass('active');
		$('#button-albumUploadStart').disable();
	},
	
	ok:function(){}
};

function reinitJScroll(arg){
	if(!arg)
	{
		setTimeout(function(){reinitJScroll('run');},300);
		return true;
	}

	$('#uploadQueLimiter').jScrollPane({'scrollbarWidth':7});
};


(function($){
	$.fn.gradualAnimation = function(time){
	
		function enlarge()
		{
			if(this.data('stopEnlarge')) return false;
	
			var width = parseInt(this.css('width'));
			if(width>=100) return false;
	
			this.stop().animate({'width':(width+6)+'%'},60*(width+10));
	
			var object = this;
			setTimeout (function (){ enlarge.call(object);},80*(width+10));
		}
	
		if(time)
			this.animate({'width':'100%'},(time+5)*1000);
		else
			enlarge.call(this);
	
		return this;
	}
	
	$.fn.stopAnimation = function(){
		return this.stop().data('stopEnlarge',true);
	}

	$.fn.zineUploadify = function(object){

		if(object.ok) manager.ok=object.ok;

		return this.uploadify({
			'uploader'	: object.uploader,
			'script'	: object.script,
			'cancelImg'	: object.cancelImg,
			'scriptData': object.scriptData,
			'method'	: object.method,
			'queueID'	: object.queueID,
			'fileDesc'	: object.fileDesc,
			'fileExt'	: object.fileExt,
			'multi'		: object.multi,
			'width'		: object.width,
			'height'	: object.height,
			'wmode'		: object.wmode,
			'hideButton': object.hideButton,
			'sizeLimit'	: object.sizeLimit,
	
			'onSelect'	: function(event,queueID, fileObj){
				manager.files.push(queueID);
				$(document).data(queueID,fileObj.size);
			},
			'onSelectOnce' : function(){
	
				$('#button-albumUploadStart').enable();
				manager.averageSpeed.begin=0;
				reinitJScroll(true);
			},
			
			'onComplete':function(event,queueID, fileObj,response,data){
	
				if(manager.currentFile.file==queueID)
				{
					manager.currentFile.finish=(new Date).getTime();		
					if(parseInt(response)==1)
					{
						manager.remove(queueID);
						manager.ok(queueID);
					}
					else manager.setError(response);
				}
	
				return false;			
			},
	
			'onCancel'	:function(event,queueID, fileObj,data){
	
				manager.removeQueueFile(queueID);
	
				if($('#uploadify'+queueID).hasClass('uploadifyError'))
				{
					$('#uploadify'+queueID+'ProgressBar').width('100%');
					return false;
				}
	
				if(!data.fileCount)
				{
					manager.restoreButtons();
				}
	
				reinitJScroll();
			},
			
			'onError' : function(e,qid){
	//			console.log("ERROR encountered");
				manager.setError(arguments[3].type + " Error");
				setTimeout(function(){
			//		$("#uploadify").uploadifyCancel(qid);
				},50);
						
				return false;
			},
			
			'onAllComplete': function(){
	
				manager.restoreButtons();
	//			manager.clearIntervals();
	//			manager.currentFile = {};
			},
			
			'onProgress':function(event,queueID, fileObj,data){
	
				if(data.percentage==100 && !manager.currentFile.finish)
					setTimeout(function(){manager.autoChecker(queueID)},25000);
				
				var avg = manager.averageSpeed;
				
				if( avg.currentFile != queueID)
				{
					if(!avg.begin)
					{
						avg.begin = (new Date()).getTime();
						avg.totSize=0;
					}
					
					avg.totSize+=fileObj.size;
					avg.currentFile = queueID;
				}
				
				return false;
			}
		});
		
	}
})(jQuery);