(function($){

	$.fn.resizeCenter = function()
	{
		var img = this;
		if(!img.data('origWidth')) return false;
		
		var ratio = img.data('origWidth')/img.data('origHeight');
		var screenRatio = $(window).width()/$(window).height();
		
		var newWidth = 0, newHeight = 0;
		
		if(ratio>screenRatio)
		{
			// Long
			newHeight = Math.min($(window).height(),img.data('origHeight'));
			newWidth = newHeight*ratio;
		}
		else
		{
			// High
			newWidth = Math.min($(window).width(),img.data('origWidth'));
			newHeight = newWidth/ratio;
		}
		
		img.css({
			width		: newWidth,
			height		: newHeight,
			top			: ($(window).height()-newHeight)/2,
			left		: ($(window).width() - newWidth)/2,
			position	: 'absolute'
		});
		
		return this;
	}

	$.fn.hdata = function(key){
		return this.find('.data .'+key).text();
	}
	
	$.fn.randomRotate = function (angleFrom,angleTo)
	{
		var rotate="";
		var diff = Math.abs(angleTo-angleFrom);
		var angle = 0;
		
		this.each(function(){
			angle = Math.random()*diff + angleFrom;
			
			var rotate = 'rotate('+angle+'deg)';
			
			var element = $(this);
			
			if(element.css('-moz-transform'))
				element.css('-moz-transform',rotate);
				
			else if(element.css('-webkit-transform'))
				element.css('-webkit-transform',rotate);
			
			else if(element.css('-o-transform'))
				element.css('-o-transform',rotate);
				
			else if(element.css('transform'))
					element.css('transform',rotate);
					
			else if(element.css("filter")!=undefined)
			{
				var outer = element.data("outer");
				if(!outer)
				{
					outer = {
						width : element.outerWidth(),
						height: element.outerHeight()
					};
					
					element.data("outer",outer);
				}
				
				var cos = Math.cos(Math.PI * 2 / 360 * angle);
				var sin = Math.sin(Math.PI * 2 / 360 * angle);

				element.css({position:"absolute"})
				element.parent().css({height:globals['picHeight']-10});
				
				element.css("filter","progid:DXImageTransform.Microsoft.Matrix(M11="+cos+",M12="+(-sin)+",M21="+sin+",M22="+cos+",SizingMethod='auto expand',FilterType='nearest neighbor')");

				element.css("left",-(Math.floor((element.width()-outer.width)/2)));
				element.css("top",-(Math.floor((element.height()-outer.height)/2)));
			}
			
		});
		
		return this;
	};
	
})(jQuery);

$.fn.thumbActive = function(){
	var thumbOverlay = $('<div class="thumbOverlay">').css('opacity',0.6).hide();
	
	this.prepend(thumbOverlay);
	thumbOverlay.stop(true,true).fadeIn();
	
	return this;
}

$.fn.thumbInactive = function(){
	return this.each(function(){
		$('.thumbOverlay',this).stop(true,true).fadeOut(function(){$(this).remove();});
	});
}

$.get = function(url, data, callback, type){
	if ($.isFunction(data))
	{
		type = type || callback;
		callback = data;
		data = null;
	}
	
	var key = $.param({"url":url,"data":data});
	var cache = getCache(key);
	var t = this;
	
	if(cache)
	{
		callback.call(t,cache);
		return;
	}
	else return $.ajax({
			type: "GET",
			url: url,
			data: data,
			success: function(msg){addCache(key,msg);callback.call(t,msg);},
			dataType: type
	});

}


function scrollPagination()
{
	if($('#paginationPanel ul li').length>11)
	{
		var pe = $('#paginationListExpand');
		var ul = $('#paginationListExpand ul');
		
		pe.height(200).unbind('mousemove').mousemove(function(e){
			if(!this.totScroll)
			{
				this.el = $(this);
				this.cHeight = this.el.height();
				this.totScroll = ul.height()-this.cHeight;
			}
			
			if(e.layerY==undefined) e.layerY=e.pageY-this.el.offset().top;

			e.layerY=Math.max(e.layerY,10);
			e.layerY=Math.min(190,e.layerY);

			ul.css({marginTop:-Math.round(((e.layerY-10)/(this.cHeight-20))*this.totScroll)});
		});
	}
}

function listenPagination()
{
	var tmpTimeOut;
	
	$('#paginationPanel .paginationList').live('mouseenter',function(){
		var tmp = $(this);
		tmpTimeOut = setTimeout(function(){tmp.click();},200);
	}).live('mouseleave',function(){
		clearTimeout(tmpTimeOut);
	}).live('click',function(){
		
		if($('#paginationPanel .button.inactive').length==2)
		return false;
		
		$('#paginationListExpand').stop(true,true).slideDown('fast');
	})
	
	$('#paginationListExpand').live('mouseleave',function(){
		$(this).stop(true,true).slideUp('fast');
	});
	
	$('#paginationListExpand ul li').live('click',function(){
		if($(this).hasClass('activeLI')) return false;
		$(this).addClass('activeLI').siblings().removeClass();
		
		var page = $(this).html();
		$('#currentPage').html(page);
		
		setTimeout(function(){
			$('#paginationListExpand').stop(true,true).slideUp('fast',function(){
				$.address.value($(page).text());
			});	
		},250);
	});
	
}
var globals = {
	perpage:0,
	picWidth : 192,
	picHeight: 192
};
var THUMBNAIL_WIDTH = 88;


$(function(){
	
	if(parseInt($('#setting-imagesRotated').html()))
	{
		globals['rotated'] = true;
//		globals['picHeight'] = 155;
	}


	$('#content').css("padding-bottom",0);

	$('a.ajax').live('click',function(e){
		
		var l = $(this).attr('href');
		l = l.replace(location.href.replace(location.hash,''),'');
		
		if($(this).hasClass('homeIcon')) l="/";
		
		$.address.value(l);
		e.preventDefault();
	});

	var firstRun = true;

	$.address.change(function(e){

		if(firstRun)
		{
			firstRun = false;
			if(location.search)
			{
				location.replace(baseURL()+'#/'+location.search);
				return false;
			}
		}
		
		globals.lastAddress = globals.addressData || {};
		globals.addressData = {};
		$.each($.address.parameterNames(),function(i,j){globals.addressData[j] = $.address.parameter(j); });

		var la = globals.lastAddress;
		var ad = globals.addressData;
		
		if(!ad['fullscreen'])
		{
			if(!ad['zoom'] && la['zoom'])
				$('#overlay').click();
		}

		if(!ad['fullscreen'] && la['fullscreen'])
			$('#overlaySlideshow').click();
		
		if(ad['fullscreen'])
		{
			if(!ad['album']) return false;
			fullscreen(ad['fullscreen']);
		}
		
		if(ad['zoom'])
		{
			if(!ad['album']) return false;
			
			zoomPic(ad['zoom']);
		}
		
		if((la.album == ad.album) && (la.page == ad.page) && (globals['lastPP']==globals['perpage']))
		return false;

		globals['lastPP'] = globals['perpage'];

		e.value = e.value.replace(/^\//,'');

		if(!e.value) e.value = baseURL();
		else if(!e.value.match(/^\?[\w\d\=\&]+$/i)) { return false; }
			
		$('#preloadScreen').fadeIn('fast');


		$.get(e.value,{perpage:globals["perpage"]},function(msg){

			var tmp = [];
			if(tmp = msg.match(/<!--\[(.*)\]-->/))
			{
				var js = $.parseJSON(tmp[1]);
				
				if(js && js['redirect'])
				{
					$.address.value(htmlDecode(js['redirect']));
					return false;
				}
			}

			$('#preloadScreen').fadeOut('fast');
			
			$('#content').html($('#content',msg).html());
			$('#paginationPanel').html($('#paginationPanel',msg).html());
			$('h1').html($('h1',msg).html());
			$('#functionalButtonArea').html($('#functionalButtonArea',msg).html());
			
			try{
				globals['prevTitle'] = htmlDecode(msg.match(/<title>(.*)<\/title>/i)[1]);
				
				if(!ad['zoom']) document.title = globals['prevTitle'];
			} catch(e){};
			
			if(globals['rotated'])
			{
				$('.picTitle').hide();
				$('.pic').randomRotate(-8,8);
			}
			
			scrollPagination();
			
			trackPageView();
		});
	});
	
	$('.zoomPic').live('click',function(e){
		
		var pic = $(this).closest(".picHolder");
		var id = pic.hdata('id');
		
		zoomPicAddress(id);		
		e.preventDefault();
	});
	
	$('#overlay').click(function(){

		if(globals['fullscreenMode'])
		{
			$('#overlaySlideshow').click();
			if(!globals['zoomMode']) return false;
		}

		$(this).stop(true,true).fadeOut('fast');
		globals['zoomMode']=false;
		globals['autostartSlideshow'] = false;
		
		$('#overlayContent').stop(true,true).fadeOut('fast');
		
		if(globals['zoomPicAjaxRequest'])
		{
			globals['zoomPicAjaxRequest'].abort();
		}
		
		document.title=globals['prevTitle'];
		$(window).resize();
		
		delete globals.addressData.zoom;
		$.address.value('?'+$.param(globals.addressData));
	});
	
	$('.thumbArrow').live('mousedown',function(){

		if($(this).hasClass('inactive')) return false;
		$(this).addClass('active');
		
		var thumbStrip = $('#thumbStrip');
		var currentMarginLeft = Math.abs(parseInt(thumbStrip.css('margin-left')));
		
		if(this.id.indexOf('right')!=-1)
		{
			var w = (thumbStrip.outerWidth()-($('#thumbSlider').outerWidth()-25));
			thumbStrip.animate({'margin-left':-w},w - currentMarginLeft);
		}
		else
			thumbStrip.animate({'margin-left':0},currentMarginLeft);
		
		
	}).live('mouseup mouseleave',function(){
		$(this).removeClass('active');
		$('#thumbStrip').stop();
	});
	
	
	$('.slideThumb').live('click',function(e,ignoreAddress){
		zoomPicAddress(parseInt($(this).hdata("id")));
	});
	
	
	$('#slideshowControls').bind('mousemove',function(e){

		if(globals['currentZoomSetCount']<2) return;

		var pos;
		var el = $(this);
		var cursorAt = e.pageX-el.offset().left;
		
		if(Math.abs(el.width()/2 - cursorAt)<60)
			pos=3;		// Neutral
		else if(cursorAt < el.width()/2)
			pos=1;		// Left
		else pos = 2;	// Right
		
		if(pos!=globals['overlayPos'])
		{
			$('.arrowHolder').stop(true,true).hide().eq(pos-1).fadeIn('fast');
			globals['overlayPos'] = pos;
		}
	}).bind('mouseenter',function(){

		$('#overlayClose,#imgTitleDescr').stop(true,true).fadeIn();
		
	}).bind('mouseleave',function(){
		
		globals['overlayPos'] = 0;
		$('.arrowHolder,#overlayClose,#imgTitleDescr').hide();
		
	});
	
	$('#overlayClose').click(function(){
		$('#overlay').click();
	});
	
	$('.slideshowPic').live('click',function(e){
		e.stopPropagation();
		return false;
	});
	
	$('#overlaySlideshow').live('click',function(){

		globals['fullscreenMode']=false;
		$('#smPause').click();

		$(this).fadeOut(function(){
			$('#slideshowModeControls').hide();
		});
		
		$(this).find('img').remove();
		
		if(globals['zoomMode'])
		{
			globals.addressData.zoom = globals['activePic'].id;
			$('#overlayContent').stop(true,true).fadeIn();
			document.title = htmlDecode(globals['activePic'].title);
		}
		else $('#overlay').click();
		
		$('#slideshowModeControls').fadeOut('fast');
		
		delete globals.addressData.fullscreen;
		$.address.value('?'+$.param(globals.addressData));
	});
	
	$('.arrowHolder').mousedown(function(e){
										 
		$('div',this).addClass('active');
		
	}).bind('mouseup mouseleave',function(){
		
		$('div',this).removeClass('active');
		
	}).click(function(){
		var toClick = 0;
		
		if($(this).hasClass('arrowLeftHolder'))
		{
			toClick = globals['activePic'].index-1;
			if(toClick<0) toClick = globals['currentZoomSetCount']-1;
		}
		else
		{
			toClick = globals['activePic'].index+1;
			if(toClick>=globals['currentZoomSetCount'])
				toClick=0;
		}
		
		$('.slideThumb:eq('+toClick+')').click();
	})
	
	$('#zoomOpenSlideshow').click(function(){
		fullscreenAddress(globals['activePic'].id);
	});
	
	$('#slideshowModeControls').mousemove(function(e){
		if(globals['hideSmTimeout'])
			clearTimeout(globals['hideSmTimeout']);

		e.stopPropagation();
	});
	
	$('#overlaySlideshow').mousemove(function(e){

		if(	globals['threshold'] &&
			Math.abs(globals['threshold'].x - e.pageX) < 3 &&
			Math.abs(globals['threshold'].y - e.pageY) < 3)
		{
			return false;
		}
		
		if(!globals['fullscreenMode']) return false;
		
		globals['threshold'] = {x:e.pageX, y:e.pageY};
		
		var elem = $('#slideshowModeControls');
		if(globals['hideSmTimeout'])
		{
			clearTimeout(globals['hideSmTimeout']);
			if(elem.is(':hidden')) elem.fadeIn('fast');
		}
		
		globals['hideSmTimeout'] = setTimeout(function(){
			elem.fadeOut();
		},2500);
	});
	
	$('#smPlay').click(function(){
		if($(this).hasClass('inactive')) return false;
		$(this).hide();
		$('#smPause').show();
		
		if(globals['slideshowTimeot']) clearInterval(globals['slideshowTimeot']);
		
		globals['slideshowTimeot'] = setInterval(function(){
			$('#smNext').trigger('click',[true]);
		},5000);
	});
	
	$('#smPause').click(function(){
		 $(this).hide();
		$('#smPlay').show();
		
		if(globals['slideshowTimeot']) clearInterval(globals['slideshowTimeot']);
	});
	
	$('#smClose').click(function(){
		$('#overlaySlideshow').click();
	});
	
	$('#smNext').click(function(e,emulated){

		if(!emulated)
		{
			$('#smPause').click();
		}
		
		if($(this).hasClass('inactive')) return false;
		if(!globals['currentSlideshowSetCount'] || globals['currentSlideshowSetCount'] < 2) return false;
		
		var current = globals['activeSlideshowPic'].index;
		var next = current+1 >= globals['currentSlideshowSetCount'] ? 0 : current+1;

		fullscreenAddress(globals['currentSlideshowSet'][next].id);
	});
	
	$('#smPrevious').click(function(){
		$('#smPause').click();
		if($(this).hasClass('inactive')) return false;
		if(!globals['currentSlideshowSetCount'] || globals['currentSlideshowSetCount'] < 2) return false;
		
		var current = globals['activeSlideshowPic'].index;
		var previous = current-1;
		if(previous<0) previous = globals['currentSlideshowSetCount']-1;
		
		fullscreenAddress(globals['currentSlideshowSet'][previous].id);
	});
	
	$('#slideshowModeControls div').mousedown(function(){
		$(this).addClass('active');
	}).bind('mouseup mouseleave',function(){
		$(this).removeClass('active');
	});
	
	var el = $(this);
		el.addClass('active');
		
	$('#funcSlideshow, #funcCarousel').live('mousedown',function(){
		$(this).addClass('active');
	}).live('mouseleave mouseup',function(){
		$(this).removeClass('active');
	})
	
	$('#funcCarousel').live('click',function(){
		zoomPicAddress($(this).find('.data').html());
	});
	
	$('#funcSlideshow').live('click',function(){
		fullscreenAddress($(this).find('.data').html());
		globals['autostartSlideshow'] = true;
	});
	
	listenPagination();
	$(window).resize();
});

$(document).bind('keydown',function(e){

	if(globals['fullscreenMode'])
	{
		switch(e.keyCode)
		{
			case 37:	// Left
				$('#smPrevious').click();
				break;
			case 39:	// Right
				$('#smNext').click();
				break;
			case 27:	// Esc
				$('#overlaySlideshow').click();
				break;
		}
	}
	else if(globals['zoomMode'])
	{
		switch(e.keyCode)
		{
			case 37:	// Left
				$('.arrowHolder').eq(0).click();
				break;
			case 39:	// Right
				$('.arrowHolder').eq(1).click();
				break;
			case 27:	// Esc
				$('#overlay').click();
				break;
		}
	}
});

$(window).resize(function(){
	
	$('#overlay').height($(window).height());

	var x = Math.max(Math.floor(($(window).width()-35)/globals['picWidth']),1),
	y = Math.max(Math.floor(($(window).height()-150)/globals['picHeight']),1);
	
	if(!globals['zoomMode'] && !globals['fullscreenMode'])
	{
		globals["oldPP"] = globals["perpage"];
		globals["perpage"] = x*y;
		
		if(globals["oldPP"] && globals["perpage"]!=globals["oldPP"])
		{
			var arr = location.hash.match(/rand=(\d+)/);
			var hash = location.hash.replace('#','');
			var rand = 'rand='+parseInt(Math.random()*10000);
			
			if(arr && arr[0])
				hash = hash.replace(arr[0],rand);
			else
				hash += hash ? '&'+rand : '?'+rand;
			
			location.replace(baseURL()+'#'+hash);
		}
	}
	
	$('#content').height(Math.max(y*globals['picHeight'],$(window).height()-160));
	$('#overlayContent').css('top',($(window).height()-$('#overlayContent').outerHeight())/2);

	var slideshowImg = $('#overlaySlideshow img').eq(0);
	if(slideshowImg)
		slideshowImg.resizeCenter();
	
});
$(window).resize();

function markThumb(index)
{
	var scrollPx = 0;
	var el = $('.slideThumb').thumbInactive().eq(index).thumbActive();
	
	if(globals['currentZoomSetCount']>7)
	{
		if((globals['currentZoomSetCount'] - index) > 3 && index > 2)
			scrollPx = -THUMBNAIL_WIDTH*(index-3);
		else if(index <= 2)
			scrollPx = 0;
		else
			scrollPx = -THUMBNAIL_WIDTH*(globals['currentZoomSetCount']-7);
		
		el.parent().stop().animate({'margin-left':scrollPx},'fast');
	}
	else el.parent().css('margin-left',0);
}

function zoomPicAddress(id)
{
	globals.addressData.zoom=id;
	$.address.value('?'+$.param(globals.addressData));
}

function zoomPic(id)
{
	if(globals['zoomMode'])
	{
		if(globals['activePic'] && id==globals['activePic'].id) return false;
		
		var found = false;
		$.each(globals['currentZoomSet'],function(i,j){
			if(id == j.id)
			{
				displayPic(j);
				markThumb(j.index);
				found=true;
				return false;
			}
		});
		
		if(found)
			return true;
	}
	
	$('#slideshowPic img').remove();
	$('#imgTitleDescr').hide().find('h2,p').empty();
	
	$('#overlay').css("opacity",0.92).addClass("loading").fadeIn(function(){
		
		var overlay = $(this);
		var overlayContent = $('#overlayContent');
		var thumbStrip = $('#thumbStrip').empty().css('margin-left',0);
		
		globals['zoomPicAjaxRequest'] = $.get("assets/ajax/zoom-pic.php",{picid:id},function(msg){
															 
			if(!msg) 
			{
				$('#overlay').click();
				return false;
			}
			
			overlay.removeClass("loading");

			var active;			
			var tot = 0;
			
			globals['currentZoomSet'] = msg.pics;

			$.each(msg.pics,function(){
				if(this.active)
					active = this;
				
				$(	'<div class="slideThumb">'+
					'<img width="80" height="60" src="'+this.imgSmall+'" />'+
					'<div class="data"><div class="id">'+this.id+'</div></div>'+
					'</div>').appendTo(thumbStrip);
				
				tot++;
			});
			
			globals['currentZoomSetCount'] = tot;
			
			thumbStrip.width(THUMBNAIL_WIDTH*tot);
			overlayContent.fadeIn();
	
			if(thumbStrip.outerWidth()<=($('#thumbSlider').outerWidth()-25))
				$('.thumbArrow').addClass('inactive');
			else $('.thumbArrow').removeClass('inactive');
			
			displayPic(active);			
			markThumb(active.index);
			
			trackPageView();
			
		},'json');
	});
	
	globals['zoomMode']=true;
	
	function displayPic(obj)
	{
		var slideshowPic = $('#slideshowPic');
		var oldImg = $('img',slideshowPic);
		
		if(oldImg.length)
		{
			oldImg.fadeOut(function(){ oldImg.remove(); });
			$('#slideshowControls').hide();
		}
		
		$('#overlay').addClass('loading');
		globals['activePic'] = obj;
		
		$("<img>").bind('load',function(){

			$('#overlay').removeClass('loading');
			
			if(globals['activePic'].id!=obj.id) return false;

			var img = $(this);

			img.hide().appendTo(slideshowPic);

			img.css({
				'margin-left':(640-img.width())/2,
				'margin-top':(480-img.height())/2
			});
			
			img.fadeIn();
			
			$('#slideshowControls').css({
				top		: img.css('margin-top'),
				left	: img.css('margin-left'),
				width	: img.width(),
				height	: img.height()
			}).fadeIn();
			
			$('#imgTitleDescr h2').html(obj.title);
			$('#imgTitleDescr p')[obj.description?'show':'hide']().html(obj.description);
			
		}).attr('src',obj.imgMid);
		
		document.title = htmlDecode(obj.title);
	}
}

function fullscreenAddress(id)
{
	if(globals['zoomMode'])
		delete globals.addressData.zoom;
	
	globals.addressData.fullscreen=id;
	$.address.value('?'+$.param(globals.addressData));
}
function fullscreen(id)
{
	if(globals['zoomMode'] && !globals['fullscreenMode'])
	{
		$('#overlay').addClass('loading');
		$('#overlayContent').stop(true,true).fadeOut();
	}

	if(globals['fullscreenMode'])
	{
		if(globals['activeSlideshowPic'] && id==globals['activeSlideshowPic'].id) return false;
		
		var found = false;
		$.each(globals['currentSlideshowSet'],function(i,j){
			if(id == j.id)
			{
				displayFullscreen(j);
				found=true;
				return false;
			}
		});
		
		if(found)
			return true;
	}
	
	globals['fullscreenMode'] = true;
	
	$('#overlay').css("opacity",0.92).addClass("loading").fadeIn(function(){

		globals['zoomPicAjaxRequest'] = $.get("assets/ajax/zoom-pic.php",{picid:id},function(msg){
			if(!msg) 
			{
				$('#overlay').click();
				return false;
			}
			
			globals['currentSlideshowSet'] = msg.pics;

			var tot=0;
			$.each(msg.pics,function(){
				if(this.active)
					active = this;
				
				tot++;
			});
			
			globals['currentSlideshowSetCount'] = tot;
			displayFullscreen(active);
		
			trackPageView();
		
		},'json');
	});
	
	function displayFullscreen(obj){
		
		globals['activeSlideshowPic'] = obj;
		
		$('#overlaySlideshow img').fadeOut();
		$('#overlay').addClass("loading");
		
		$("<img>").bind('load',function(){
			if(globals['activeSlideshowPic'].id!=obj.id || !globals['fullscreenMode']) return false;

			$('#overlay').removeClass("loading");
			var img = $(this).addClass('slideshowPic');

			img.hide().prependTo($('#overlaySlideshow').show());
			
			img.data('origWidth',img.width()).data('origHeight',img.height());

			img.resizeCenter().fadeIn(function(){
				$('#overlaySlideshow img').not(this).stop().remove();
			});
			
			if(globals['autostartSlideshow'])
			{
				$('#smPlay').click();
				globals['autostartSlideshow'] = false;
			}
			
			if(globals['currentSlideshowSetCount']>1)
			{
				$('#slideshowModeControls div').removeClass('inactive');
				
				var previous = 	obj.index-1;
				if(previous<0) previous = globals['currentSlideshowSetCount']-1;
				
				var next = obj.index+1;
				if(next >= globals['currentSlideshowSetCount']) next=0;
				
				$.each(globals['currentSlideshowSet'],function(i,j){
					if(i == previous || i == next)
					{
						(new Image()).src = j.imgBig;
					}
				});

			}
			else $('#slideshowModeControls div:not(:last)').addClass('inactive');
			
		}).attr('src',obj.imgBig);

		document.title = htmlDecode(obj.title);
	}
}

function baseURL()
{
	return location.href.replace(location.search,'').replace(location.hash,'').replace('#','');
}

function htmlDecode(str)
{
	return $('<textarea>').html(str).val();
}

function addCache(key,cache)
{
	if(cacheExists(key) !== false) return false;
	
	if(!globals['cache'])
		globals['cache'] = new Array();
	
	globals['cache'].unshift({
		"key"	: key,
		"cache"	: cache
	});
	
	if(typeof globals['cache'][20] != 'undefined')
		globals['cache'].pop();
	
	return true;
}

function cacheExists(key)
{
	if(!globals['cache'] || globals['cache'].length<1) return false;
	
	for(var i=0;i<globals['cache'].length;i++)
	{
		if(globals['cache'][i].key == key) return i;
	}
	
	return false;
}

function getCache(key)
{
	var index;
	
	if((index = cacheExists(key)) !== false)
		return globals['cache'][index].cache;
	return false;
}

function trackPageView(str)
{
	if(!str) str = location.hash.substr(1);

	try{
		pageTracker._trackPageview(str);
	} catch(e){}
}